package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NamespaceStatus is information about the current status of a Namespace.
 *
 *  @param conditions  Represents the latest available observations of a namespace's current state.
 *  @param      phase  Phase is the current lifecycle phase of the namespace. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
*/
case class NamespaceStatus(
  conditions: Option[Seq[io.k8s.api.core.v1.NamespaceCondition]] = None,
  phase: Option[String] = None
)

object NamespaceStatus {
  implicit lazy val encoder: Encoder.AsObject[NamespaceStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[NamespaceStatus] = deriveDecoder
}
