package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of fields are allowed
 *
 *  @param           ipBlock  IPBlock defines policy on a particular IPBlock. If this field is set then neither of the other
 *                            fields can be.
 *  @param namespaceSelector  Selects Namespaces using cluster-scoped labels. This field follows standard label selector semantics;
 *                            if present but empty, it selects all namespaces.
 *                            If PodSelector is also set, then the NetworkPolicyPeer as a whole selects the Pods matching PodSelector
 *                            in the Namespaces selected by NamespaceSelector. Otherwise it selects all Pods in the Namespaces
 *                            selected by NamespaceSelector.
 *  @param       podSelector  This is a label selector which selects Pods. This field follows standard label selector semantics;
 *                            if present but empty, it selects all pods.
 *                            If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the Pods matching
 *                            PodSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the Pods matching
 *                            PodSelector in the policy's own Namespace.
*/
case class NetworkPolicyPeer(
  ipBlock: Option[io.k8s.api.networking.v1.IPBlock] = None,
  namespaceSelector: Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  podSelector: Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
)

object NetworkPolicyPeer {
  implicit lazy val encoder: Encoder.AsObject[NetworkPolicyPeer] = deriveEncoder
  implicit lazy val decoder: Decoder[NetworkPolicyPeer] = deriveDecoder
}
