package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NetworkPolicyStatus describe the current state of the NetworkPolicy.
 *
 *  @param conditions  Conditions holds an array of metav1.Condition that describe the state of the NetworkPolicy. Current
 *                     service state
*/
case class NetworkPolicyStatus(
  conditions: Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]] = None
)

object NetworkPolicyStatus {
  implicit lazy val encoder: Encoder.AsObject[NetworkPolicyStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[NetworkPolicyStatus] = deriveDecoder
}
