package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms.
 *
 *  @param nodeSelectorTerms  Required. A list of node selector terms. The terms are ORed.
*/
case class NodeSelector(
  nodeSelectorTerms: Seq[io.k8s.api.core.v1.NodeSelectorTerm]
)

object NodeSelector {
  implicit lazy val encoder: Encoder.AsObject[NodeSelector] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeSelector] = deriveDecoder
}
