package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
 *
 *  @param matchExpressions  A list of node selector requirements by node's labels.
 *  @param      matchFields  A list of node selector requirements by node's fields.
*/
case class NodeSelectorTerm(
  matchExpressions: Option[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]] = None,
  matchFields: Option[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]] = None
)

object NodeSelectorTerm {
  implicit lazy val encoder: Encoder.AsObject[NodeSelectorTerm] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeSelectorTerm] = deriveDecoder
}
