package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ObjectFieldSelector selects an APIVersioned field of an object.
 *
 *  @param  fieldPath  Path of the field to select in the specified API version.
 *  @param apiVersion  Version of the schema the FieldPath is written in terms of, defaults to "v1".
*/
case class ObjectFieldSelector(
  fieldPath: String,
  apiVersion: Option[String] = None
)

object ObjectFieldSelector {
  implicit lazy val encoder: Encoder.AsObject[ObjectFieldSelector] = deriveEncoder
  implicit lazy val decoder: Decoder[ObjectFieldSelector] = deriveDecoder
}
