package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PersistentVolumeStatus is the current status of a persistent volume.
 *
 *  @param message  message is a human-readable message indicating details about why the volume is in this state.
 *  @param   phase  phase indicates if a volume is available, bound to a claim, or released by a claim. More info:
 *                  https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
 *  @param  reason  reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy
 *                  display in the CLI.
*/
case class PersistentVolumeStatus(
  message: Option[String] = None,
  phase: Option[String] = None,
  reason: Option[String] = None
)

object PersistentVolumeStatus {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolumeStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolumeStatus] = deriveDecoder
}
