package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Pod is a collection of containers that can run on a host. This resource is created by clients and scheduled onto hosts.
 *
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param       spec  Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
 *  @param     status  Most recently observed status of the pod. This data may not be up to date. Populated by the system.
 *                     Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
*/
case class Pod(
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec: Option[io.k8s.api.core.v1.PodSpec] = None,
  status: Option[io.k8s.api.core.v1.PodStatus] = None
)

object Pod {
  implicit lazy val encoder: Encoder.AsObject[Pod] = deriveEncoder
  implicit lazy val decoder: Decoder[Pod] = deriveDecoder
}
