package io.k8s.api.policy.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodDisruptionBudgetList is a collection of PodDisruptionBudgets.
 *
 *  @param      items  Items is a list of PodDisruptionBudgets
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
*/
case class PodDisruptionBudgetList(
  items: Seq[io.k8s.api.policy.v1.PodDisruptionBudget],
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
)

object PodDisruptionBudgetList {
  implicit lazy val encoder: Encoder.AsObject[PodDisruptionBudgetList] = deriveEncoder
  implicit lazy val decoder: Decoder[PodDisruptionBudgetList] = deriveDecoder
}
