package io.k8s.api.batch.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodFailurePolicyOnPodConditionsPattern describes a pattern for matching an actual pod condition type.
 *
 *  @param `type`  Specifies the required Pod condition type. To match a pod condition it is required that specified type equals
 *                 the pod condition type.
 *  @param status  Specifies the required Pod condition status. To match a pod condition it is required that the specified
 *                 status equals the pod condition status. Defaults to True.
*/
case class PodFailurePolicyOnPodConditionsPattern(
  `type`: String,
  status: String
)

object PodFailurePolicyOnPodConditionsPattern {
  implicit lazy val encoder: Encoder.AsObject[PodFailurePolicyOnPodConditionsPattern] = deriveEncoder
  implicit lazy val decoder: Decoder[PodFailurePolicyOnPodConditionsPattern] = deriveDecoder
}
