package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodTemplate describes a template for creating copies of a predefined pod.
 *
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param   template  Template defines the pods that will be created from this pod template. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
*/
case class PodTemplate(
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  template: Option[io.k8s.api.core.v1.PodTemplateSpec] = None
)

object PodTemplate {
  implicit lazy val encoder: Encoder.AsObject[PodTemplate] = deriveEncoder
  implicit lazy val decoder: Decoder[PodTemplate] = deriveDecoder
}
