package io.k8s.api.rbac.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.
 *
 *  @param           verbs  Verbs is a list of Verbs that apply to ALL the ResourceKinds contained in this rule. '*' represents
 *                          all verbs.
 *  @param       apiGroups  APIGroups is the name of the APIGroup that contains the resources.  If multiple API groups are
 *                          specified, any action requested against one of the enumerated resources in any API group will be
 *                          allowed. "" represents the core API group and "*" represents all API groups.
 *  @param nonResourceURLs  NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but
 *                          only as the full, final step in the path Since non-resource URLs are not namespaced, this field
 *                          is only applicable for ClusterRoles referenced from a ClusterRoleBinding. Rules can either apply
 *                          to API resources (such as "pods" or "secrets") or non-resource URL paths (such as "/api"),  but
 *                          not both.
 *  @param   resourceNames  ResourceNames is an optional white list of names that the rule applies to.  An empty set means
 *                          that everything is allowed.
 *  @param       resources  Resources is a list of resources this rule applies to. '*' represents all resources.
*/
case class PolicyRule(
  verbs: Seq[String],
  apiGroups: Option[Seq[String]] = None,
  nonResourceURLs: Option[Seq[String]] = None,
  resourceNames: Option[Seq[String]] = None,
  resources: Option[Seq[String]] = None
)

object PolicyRule {
  implicit lazy val encoder: Encoder.AsObject[PolicyRule] = deriveEncoder
  implicit lazy val decoder: Decoder[PolicyRule] = deriveDecoder
}
