package io.k8s.apimachinery.pkg.apis.meta.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.
 *
 *  @param resourceVersion  Specifies the target ResourceVersion
 *  @param             uid  Specifies the target UID.
*/
case class Preconditions(
  resourceVersion: Option[String] = None,
  uid: Option[String] = None
)

object Preconditions {
  implicit lazy val encoder: Encoder.AsObject[Preconditions] = deriveEncoder
  implicit lazy val decoder: Decoder[Preconditions] = deriveDecoder
}
