package io.k8s.apimachinery.pkg.api.resource

import io.circe.*

case class Quantity(value: String) extends AnyVal

object Quantity {
  implicit val encoder: Encoder[Quantity] = obj => Json.fromString(obj.value)
  implicit val decoder: Decoder[Quantity] = _.as[String].map(Quantity(_))
}