package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.
 *
 *  @param  monitors  monitors is a collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
 *  @param     image  image is the rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
 *  @param    fsType  fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type
 *                    is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be
 *                    "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
 *  @param   keyring  keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info:
 *                    https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
 *  @param      pool  pool is the rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
 *  @param  readOnly  readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info:
 *                    https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
 *  @param secretRef  secretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is
 *                    nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
 *  @param      user  user is the rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
*/
case class RBDPersistentVolumeSource(
  monitors: Seq[String],
  image: String,
  fsType: Option[String] = None,
  keyring: Option[String] = None,
  pool: Option[String] = None,
  readOnly: Option[Boolean] = None,
  secretRef: Option[io.k8s.api.core.v1.SecretReference] = None,
  user: Option[String] = None
)

object RBDPersistentVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[RBDPersistentVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[RBDPersistentVolumeSource] = deriveDecoder
}
