package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ReplicaSetSpec is the specification of a ReplicaSet.
 *
 *  @param        selector  Selector is a label query over pods that should match the replica count. Label keys and values
 *                          that must match in order to be controlled by this replica set. It must match the pod template's
 *                          labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
 *  @param minReadySeconds  Minimum number of seconds for which a newly created pod should be ready without any of its container
 *                          crashing, for it to be considered available. Defaults to 0 (pod will be considered available as
 *                          soon as it is ready)
 *  @param        replicas  Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero
 *                          and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
 *  @param        template  Template is the object that describes the pod that will be created if insufficient replicas are
 *                          detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
*/
case class ReplicaSetSpec(
  selector: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector,
  minReadySeconds: Option[Int] = None,
  replicas: Option[Int] = None,
  template: Option[io.k8s.api.core.v1.PodTemplateSpec] = None
)

object ReplicaSetSpec {
  implicit lazy val encoder: Encoder.AsObject[ReplicaSetSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[ReplicaSetSpec] = deriveDecoder
}
