package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ReplicationControllerStatus represents the current status of a replication controller.
 *
 *  @param             replicas  Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
 *  @param    availableReplicas  The number of available replicas (ready for at least minReadySeconds) for this replication
 *                               controller.
 *  @param           conditions  Represents the latest available observations of a replication controller's current state.
 *  @param fullyLabeledReplicas  The number of pods that have labels matching the labels of the pod template of the replication
 *                               controller.
 *  @param   observedGeneration  ObservedGeneration reflects the generation of the most recently observed replication controller
 *  @param        readyReplicas  The number of ready replicas for this replication controller.
*/
case class ReplicationControllerStatus(
  replicas: Int,
  availableReplicas: Option[Int] = None,
  conditions: Option[Seq[io.k8s.api.core.v1.ReplicationControllerCondition]] = None,
  fullyLabeledReplicas: Option[Int] = None,
  observedGeneration: Option[Long] = None,
  readyReplicas: Option[Int] = None
)

object ReplicationControllerStatus {
  implicit lazy val encoder: Encoder.AsObject[ReplicationControllerStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[ReplicationControllerStatus] = deriveDecoder
}
