package io.k8s.api.rbac.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** RoleBindingList is a collection of RoleBindings
 *
 *  @param      items  Items is a list of RoleBindings
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata.
*/
case class RoleBindingList(
  items: Seq[io.k8s.api.rbac.v1.RoleBinding],
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
)

object RoleBindingList {
  implicit lazy val encoder: Encoder.AsObject[RoleBindingList] = deriveEncoder
  implicit lazy val decoder: Decoder[RoleBindingList] = deriveDecoder
}
