package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** SELinuxOptions are the labels to be applied to the container
 *
 *  @param  level  Level is SELinux level label that applies to the container.
 *  @param   role  Role is a SELinux role label that applies to the container.
 *  @param `type`  Type is a SELinux type label that applies to the container.
 *  @param   user  User is a SELinux user label that applies to the container.
*/
case class SELinuxOptions(
  level: Option[String] = None,
  role: Option[String] = None,
  `type`: Option[String] = None,
  user: Option[String] = None
)

object SELinuxOptions {
  implicit lazy val encoder: Encoder.AsObject[SELinuxOptions] = deriveEncoder
  implicit lazy val decoder: Decoder[SELinuxOptions] = deriveDecoder
}
