package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** A scope selector represents the AND of the selectors represented by the scoped-resource selector requirements.
 *
 *  @param matchExpressions  A list of scope selector requirements by scope of the resources.
*/
case class ScopeSelector(
  matchExpressions: Option[Seq[io.k8s.api.core.v1.ScopedResourceSelectorRequirement]] = None
)

object ScopeSelector {
  implicit lazy val encoder: Encoder.AsObject[ScopeSelector] = deriveEncoder
  implicit lazy val decoder: Decoder[ScopeSelector] = deriveDecoder
}
