package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace
 *
 *  @param      name  name is unique within a namespace to reference a secret resource.
 *  @param namespace  namespace defines the space within which the secret name must be unique.
*/
case class SecretReference(
  name: Option[String] = None,
  namespace: Option[String] = None
)

object SecretReference {
  implicit lazy val encoder: Encoder.AsObject[SecretReference] = deriveEncoder
  implicit lazy val decoder: Decoder[SecretReference] = deriveDecoder
}
