package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets
 *
 *  @param                   apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers
 *                                       should convert recognized schemas to the latest internal value, and may reject unrecognized
 *                                       values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param automountServiceAccountToken  AutomountServiceAccountToken indicates whether pods running as this service account
 *                                       should have an API token automatically mounted. Can be overridden at the pod level.
 *  @param             imagePullSecrets  ImagePullSecrets is a list of references to secrets in the same namespace to use for
 *                                       pulling any images in pods that reference this ServiceAccount. ImagePullSecrets are
 *                                       distinct from Secrets because Secrets can be mounted in the pod, but ImagePullSecrets
 *                                       are only accessed by the kubelet. More info: https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod
 *  @param                         kind  Kind is a string value representing the REST resource this object represents. Servers
 *                                       may infer this from the endpoint the client submits requests to. Cannot be updated.
 *                                       In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param                     metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param                      secrets  Secrets is a list of the secrets in the same namespace that pods running using this
 *                                       ServiceAccount are allowed to use. Pods are only limited to this list if this service
 *                                       account has a "kubernetes.io/enforce-mountable-secrets" annotation set to "true". This
 *                                       field should not be used to find auto-generated service account token secrets for use
 *                                       outside of pods. Instead, tokens can be requested directly using the TokenRequest API,
 *                                       or service account token secrets can be manually created. More info:
 *                                       https://kubernetes.io/docs/concepts/configuration/secret
*/
case class ServiceAccount(
  apiVersion: Option[String] = None,
  automountServiceAccountToken: Option[Boolean] = None,
  imagePullSecrets: Option[Seq[io.k8s.api.core.v1.LocalObjectReference]] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  secrets: Option[Seq[io.k8s.api.core.v1.ObjectReference]] = None
)

object ServiceAccount {
  implicit lazy val encoder: Encoder.AsObject[ServiceAccount] = deriveEncoder
  implicit lazy val decoder: Decoder[ServiceAccount] = deriveDecoder
}
