package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ServiceReference holds a reference to Service.legacy.k8s.io
 *
 *  @param namespace  namespace is the namespace of the service. Required
 *  @param      name  name is the name of the service. Required
 *  @param      path  path is an optional URL path at which the webhook will be contacted.
 *  @param      port  port is an optional service port at which the webhook will be contacted. `port` should be a valid port
 *                    number (1-65535, inclusive). Defaults to 443 for backward compatibility.
*/
case class ServiceReference(
  namespace: String,
  name: String,
  path: Option[String] = None,
  port: Option[Int] = None
)

object ServiceReference {
  implicit lazy val encoder: Encoder.AsObject[ServiceReference] = deriveEncoder
  implicit lazy val decoder: Decoder[ServiceReference] = deriveDecoder
}
