package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.
 *
 *  @param whenDeleted  WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet
 *                      is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The
 *                      `Delete` policy causes those PVCs to be deleted.
 *  @param  whenScaled  WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet
 *                      is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete`
 *                      policy causes the associated PVCs for any excess pods above the replica count to be deleted.
*/
case class StatefulSetPersistentVolumeClaimRetentionPolicy(
  whenDeleted: Option[String] = None,
  whenScaled: Option[String] = None
)

object StatefulSetPersistentVolumeClaimRetentionPolicy {
  implicit lazy val encoder: Encoder.AsObject[StatefulSetPersistentVolumeClaimRetentionPolicy] = deriveEncoder
  implicit lazy val decoder: Decoder[StatefulSetPersistentVolumeClaimRetentionPolicy] = deriveDecoder
}
