package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
 *
 *  @param rollingUpdate  RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
 *  @param        `type`  Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
*/
case class StatefulSetUpdateStrategy(
  rollingUpdate: Option[io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy] = None,
  `type`: Option[String] = None
)

object StatefulSetUpdateStrategy {
  implicit lazy val encoder: Encoder.AsObject[StatefulSetUpdateStrategy] = deriveEncoder
  implicit lazy val decoder: Decoder[StatefulSetUpdateStrategy] = deriveDecoder
}
