package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Sysctl defines a kernel parameter to be set
 *
 *  @param  name  Name of a property to set
 *  @param value  Value of a property to set
*/
case class Sysctl(
  name: String,
  value: String
)

object Sysctl {
  implicit lazy val encoder: Encoder.AsObject[Sysctl] = deriveEncoder
  implicit lazy val decoder: Decoder[Sysctl] = deriveDecoder
}
