package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** The pod this Toleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
 *
 *  @param            effect  Effect indicates the taint effect to match. Empty means match all taint effects. When specified,
 *                            allowed values are NoSchedule, PreferNoSchedule and NoExecute.
 *  @param               key  Key is the taint key that the toleration applies to. Empty means match all taint keys. If the
 *                            key is empty, operator must be Exists; this combination means to match all values and all keys.
 *  @param          operator  Operator represents a key's relationship to the value. Valid operators are Exists and Equal.
 *                            Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all
 *                            taints of a particular category.
 *  @param tolerationSeconds  TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute,
 *                            otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate
 *                            the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately)
 *                            by the system.
 *  @param             value  Value is the taint value the toleration matches to. If the operator is Exists, the value should
 *                            be empty, otherwise just a regular string.
*/
case class Toleration(
  effect: Option[String] = None,
  key: Option[String] = None,
  operator: Option[String] = None,
  tolerationSeconds: Option[Long] = None,
  value: Option[String] = None
)

object Toleration {
  implicit lazy val encoder: Encoder.AsObject[Toleration] = deriveEncoder
  implicit lazy val decoder: Decoder[Toleration] = deriveDecoder
}
