package io.k8s.api.batch.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** UncountedTerminatedPods holds UIDs of Pods that have terminated but haven't been accounted in Job status counters.
 *
 *  @param    failed  Failed holds UIDs of failed Pods.
 *  @param succeeded  Succeeded holds UIDs of succeeded Pods.
*/
case class UncountedTerminatedPods(
  failed: Option[Seq[String]] = None,
  succeeded: Option[Seq[String]] = None
)

object UncountedTerminatedPods {
  implicit lazy val encoder: Encoder.AsObject[UncountedTerminatedPods] = deriveEncoder
  implicit lazy val decoder: Decoder[UncountedTerminatedPods] = deriveDecoder
}
