package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** VolumeMount describes a mounting of a Volume within a container.
 *
 *  @param             name  This must match the Name of a Volume.
 *  @param        mountPath  Path within the container at which the volume should be mounted.  Must not contain ':'.
 *  @param mountPropagation  mountPropagation determines how mounts are propagated from the host to container and the other
 *                           way around. When not set, MountPropagationNone is used. This field is beta in 1.10.
 *  @param         readOnly  Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.
 *  @param          subPath  Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's
 *                           root).
 *  @param      subPathExpr  Expanded path within the volume from which the container's volume should be mounted. Behaves similarly
 *                           to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment.
 *                           Defaults to "" (volume's root). SubPathExpr and SubPath are mutually exclusive.
*/
case class VolumeMount(
  name: String,
  mountPath: String,
  mountPropagation: Option[String] = None,
  readOnly: Option[Boolean] = None,
  subPath: Option[String] = None,
  subPathExpr: Option[String] = None
)

object VolumeMount {
  implicit lazy val encoder: Encoder.AsObject[VolumeMount] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeMount] = deriveDecoder
}
