package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from.
 *
 *  @param required  required specifies hard node constraints that must be met.
*/
case class VolumeNodeAffinity(
  required: Option[io.k8s.api.core.v1.NodeSelector] = None
)

object VolumeNodeAffinity {
  implicit lazy val encoder: Encoder.AsObject[VolumeNodeAffinity] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeNodeAffinity] = deriveDecoder
}
