package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Projection that may be projected along with other supported volume types
 *
 *  @param           configMap  configMap information about the configMap data to project
 *  @param         downwardAPI  downwardAPI information about the downwardAPI data to project
 *  @param              secret  secret information about the secret data to project
 *  @param serviceAccountToken  serviceAccountToken is information about the serviceAccountToken data to project
*/
case class VolumeProjection(
  configMap: Option[io.k8s.api.core.v1.ConfigMapProjection] = None,
  downwardAPI: Option[io.k8s.api.core.v1.DownwardAPIProjection] = None,
  secret: Option[io.k8s.api.core.v1.SecretProjection] = None,
  serviceAccountToken: Option[io.k8s.api.core.v1.ServiceAccountTokenProjection] = None
)

object VolumeProjection {
  implicit lazy val encoder: Encoder.AsObject[VolumeProjection] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeProjection] = deriveDecoder
}
