package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** WebhookConversion describes how to call a conversion webhook
 *
 *  @param conversionReviewVersions  conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the
 *                                   Webhook expects. The API server will use the first version in the list which it supports.
 *                                   If none of the versions specified in this list are supported by API server, conversion
 *                                   will fail for the custom resource. If a persisted Webhook configuration specifies allowed
 *                                   versions and does not include any versions known to the API Server, calls to the webhook
 *                                   will fail.
 *  @param             clientConfig  clientConfig is the instructions for how to call the webhook if strategy is `Webhook`.
*/
case class WebhookConversion(
  conversionReviewVersions: Seq[String],
  clientConfig: Option[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.WebhookClientConfig] = None
)

object WebhookConversion {
  implicit lazy val encoder: Encoder.AsObject[WebhookConversion] = deriveEncoder
  implicit lazy val decoder: Decoder[WebhookConversion] = deriveDecoder
}
