package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s)
 *
 *  @param          weight  weight associated with matching the corresponding podAffinityTerm, in the range 1-100.
 *  @param podAffinityTerm  Required. A pod affinity term, associated with the corresponding weight.
*/
case class WeightedPodAffinityTerm(
  weight: Int,
  podAffinityTerm: io.k8s.api.core.v1.PodAffinityTerm
)

object WeightedPodAffinityTerm {
  implicit lazy val encoder: Encoder.AsObject[WeightedPodAffinityTerm] = deriveEncoder
  implicit lazy val decoder: Decoder[WeightedPodAffinityTerm] = deriveDecoder
}
