/*
 * Decompiled with CFR 0.152.
 */
package com.goyeau.kubernetes.client.api;

import cats.ApplicativeError;
import cats.Apply;
import cats.effect.kernel.Async;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.EitherIdOps$;
import cats.syntax.EitherOps$;
import cats.syntax.FlattenOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.goyeau.kubernetes.client.KubeConfig;
import com.goyeau.kubernetes.client.api.ExecRouting$;
import com.goyeau.kubernetes.client.api.ExecStream;
import com.goyeau.kubernetes.client.api.ExecStream$StdErr$;
import com.goyeau.kubernetes.client.api.ExecStream$StdOut$;
import com.goyeau.kubernetes.client.api.ParseFailure;
import com.goyeau.kubernetes.client.api.ParseFailure$;
import com.goyeau.kubernetes.client.operation.Creatable;
import com.goyeau.kubernetes.client.operation.Deletable;
import com.goyeau.kubernetes.client.operation.DeletableTerminated;
import com.goyeau.kubernetes.client.operation.Gettable;
import com.goyeau.kubernetes.client.operation.GroupDeletable;
import com.goyeau.kubernetes.client.operation.Listable;
import com.goyeau.kubernetes.client.operation.Proxy;
import com.goyeau.kubernetes.client.operation.Replaceable;
import com.goyeau.kubernetes.client.operation.Watchable;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.Signal;
import fs2.concurrent.SignallingRef;
import fs2.concurrent.SignallingRef$;
import fs2.io.file.Files$;
import fs2.io.file.Flags$;
import fs2.io.file.Path$;
import io.circe.Decoder;
import io.circe.Encoder;
import io.circe.Error;
import io.k8s.api.core.v1.Pod;
import io.k8s.api.core.v1.PodList;
import io.k8s.apimachinery.pkg.apis.meta.v1.Status;
import io.k8s.apimachinery.pkg.apis.meta.v1.Status$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import org.http4s.Charset$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.QueryParamEncoder$;
import org.http4s.QueryParamKeyLike$;
import org.http4s.Request$;
import org.http4s.Response;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.client.Client;
import org.http4s.jdkhttpclient.WSClient;
import org.http4s.jdkhttpclient.WSConnectionHighLevel;
import org.http4s.jdkhttpclient.WSDataFrame;
import org.http4s.jdkhttpclient.WSFrame;
import org.http4s.jdkhttpclient.WSRequest$;
import org.typelevel.ci.CIString$;
import org.typelevel.jawn.Facade;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.Logger$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public class NamespacedPodsApi<F>
implements Creatable<F, Pod>,
Replaceable<F, Pod>,
Gettable<F, Pod>,
Listable<F, PodList>,
Proxy<F>,
Deletable<F>,
DeletableTerminated<F>,
GroupDeletable<F>,
Watchable<F, Pod> {
    private Facade parserFacade;
    private final Client httpClient;
    private final WSClient<F> wsClient;
    private final KubeConfig config;
    private final Option authorization;
    private final Async F;
    private final Encoder resourceEncoder;
    private final Decoder resourceDecoder;
    private final Decoder listDecoder;
    private final Logger logger;
    private final Uri resourceUri;
    private final Uri webSocketAddress;

    public NamespacedPodsApi(Client<F> httpClient, WSClient<F> wsClient, KubeConfig<F> config, Option<Object> authorization, String namespace, Async<F> F, Encoder<Pod> resourceEncoder, Decoder<Pod> resourceDecoder, Decoder<PodList> listDecoder, Logger<F> logger) {
        this.httpClient = httpClient;
        this.wsClient = wsClient;
        this.config = config;
        this.authorization = authorization;
        this.F = F;
        this.resourceEncoder = resourceEncoder;
        this.resourceDecoder = resourceDecoder;
        this.listDecoder = listDecoder;
        this.logger = logger;
        Watchable.$init$(this);
        this.resourceUri = Uri$.MODULE$.unsafeFromString("/api").$div("v1").$div("namespaces").$div(namespace).$div("pods");
        this.webSocketAddress = Uri$.MODULE$.unsafeFromString(config.server().toString().replaceFirst("http", "ws"));
        Statics.releaseFence();
    }

    @Override
    public Facade parserFacade() {
        return this.parserFacade;
    }

    @Override
    public void com$goyeau$kubernetes$client$operation$Watchable$_setter_$parserFacade_$eq(Facade x$0) {
        this.parserFacade = x$0;
    }

    @Override
    public Client<F> httpClient() {
        return this.httpClient;
    }

    @Override
    public KubeConfig<F> config() {
        return this.config;
    }

    @Override
    public Option<F> authorization() {
        return this.authorization;
    }

    @Override
    public Async<F> F() {
        return this.F;
    }

    @Override
    public Encoder<Pod> resourceEncoder() {
        return this.resourceEncoder;
    }

    @Override
    public Decoder<Pod> resourceDecoder() {
        return this.resourceDecoder;
    }

    @Override
    public Decoder<PodList> listDecoder() {
        return this.listDecoder;
    }

    public Logger<F> logger() {
        return this.logger;
    }

    @Override
    public Uri resourceUri() {
        return this.resourceUri;
    }

    private F execRequest(String podName, Seq<String> commands, Option<String> container, boolean stdin, boolean stdout, boolean stderr, boolean tty) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"stdin");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stdout");
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stderr");
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"tty");
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"container");
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"command");
        Uri uri = (Uri)this.webSocketAddress.resolve(this.resourceUri()).$div(podName).$div("exec").$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)stdin).toString()), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToBoolean((boolean)stdout).toString()), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToBoolean((boolean)stderr).toString()), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BoxesRunTime.boxToBoolean((boolean)tty).toString()), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, container), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, commands), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder());
        Method method = Method$.MODULE$.POST();
        List list = WSRequest$.MODULE$.$lessinit$greater$default$2();
        return (F)package.all$.MODULE$.toFunctorOps(com.goyeau.kubernetes.client.operation.package$.MODULE$.KubernetesWsRequestOps(WSRequest$.MODULE$.apply(uri, list, method), this.F()).withOptionalAuthorization(this.authorization()), this.F()).map((Function1 & Serializable)r -> {
            List list = Headers$.MODULE$.put$extension(r.headers(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.rawToRaw(Header.Raw$.MODULE$.apply(CIString$.MODULE$.apply("Sec-WebSocket-Protocol"), "v4.channel.k8s.io"))}));
            Uri uri = r.copy$default$1();
            Method method = r.copy$default$3();
            return r.copy(uri, list, method);
        });
    }

    private boolean execRequest$default$4() {
        return false;
    }

    private boolean execRequest$default$5() {
        return true;
    }

    private boolean execRequest$default$6() {
        return true;
    }

    private boolean execRequest$default$7() {
        return false;
    }

    public F downloadFile(String podName, Path sourceFile, Path destinationFile, Option<String> container) {
        return this.download(podName, Path$.MODULE$.fromNioPath(sourceFile), Path$.MODULE$.fromNioPath(destinationFile), container);
    }

    public Option<String> downloadFile$default$4() {
        return None$.MODULE$;
    }

    public F download(String podName, fs2.io.file.Path sourceFile, fs2.io.file.Path destinationFile, Option<String> container) {
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(this.F().ref((Object)scala.package$.MODULE$.List().empty()), this.F().ref((Object)package.all$.MODULE$.none()))).tupled(this.F(), this.F()), this.F()).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Ref stdErr = (Ref)tuple2._1();
                Ref errorOrStatus = (Ref)tuple2._2();
                return package.all$.MODULE$.toFlatMapOps(this.execRequest(podName, (Seq<String>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sh", "-c", "cat " + sourceFile.toString()}))), container, this.execRequest$default$4(), this.execRequest$default$5(), this.execRequest$default$6(), this.execRequest$default$7()), this.F()).flatMap((Function1 & Serializable)request -> this.wsClient.connectHighLevel(request).use((Function1 & Serializable)connection -> package.all$.MODULE$.toFlatMapOps(connection.receiveStream().through(this.processWebSocketData()).evalMapFilter((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        ExecStream execStream = (ExecStream)((Left)either).value();
                        if (execStream instanceof ExecStream.StdOut) {
                            byte[] byArray;
                            ExecStream.StdOut stdOut = ExecStream$StdOut$.MODULE$.unapply((ExecStream.StdOut)execStream);
                            byte[] data = byArray = stdOut._1();
                            Chunk chunk = (Chunk)package.all$.MODULE$.catsSyntaxOptionId((Object)Chunk$.MODULE$.array((Object)data, ClassTag$.MODULE$.apply(Byte.TYPE)));
                            Option option = (Option)package.all$.MODULE$.catsSyntaxApplicativeId((Object)OptionIdOps$.MODULE$.some$extension((Object)chunk));
                            return ApplicativeIdOps$.MODULE$.pure$extension((Object)option, this.F());
                        }
                        if (execStream instanceof ExecStream.StdErr) {
                            ExecStream.StdErr e = (ExecStream.StdErr)execStream;
                            return package.all$.MODULE$.toFunctorOps(stdErr.update((Function1 & Serializable)_$3 -> _$3.$colon$colon((Object)e)), this.F()).as((Object)None$.MODULE$);
                        }
                    }
                    if (either instanceof Right) {
                        Either statusOrError = (Either)((Right)either).value();
                        return package.all$.MODULE$.toFunctorOps(errorOrStatus.update((Function1 & Serializable)_$4 -> _$4.orElse(() -> NamespacedPodsApi.download$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(statusOrError))), this.F()).as((Object)None$.MODULE$);
                    }
                    throw new MatchError((Object)either);
                }).unchunks((.less.colon.less)$less$colon$less$.MODULE$.refl()).through(Files$.MODULE$.apply(Files$.MODULE$.implicitForAsync(this.F())).writeAll(destinationFile)).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F()))).drain(), this.F()).flatMap((Function1 & Serializable)_$5 -> package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(stdErr.get(), this.F()).map((Function1 & Serializable)_$6 -> _$6.reverse()), errorOrStatus.get())).tupled(this.F(), this.F())), this.F()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Option<String> download$default$4() {
        return None$.MODULE$;
    }

    public F uploadFile(String podName, Path sourceFile, Path destinationFile, Option<String> container) {
        return this.upload(podName, Path$.MODULE$.fromNioPath(sourceFile), Path$.MODULE$.fromNioPath(destinationFile), container);
    }

    public Option<String> uploadFile$default$4() {
        return None$.MODULE$;
    }

    public F upload(String podName, fs2.io.file.Path sourceFile, fs2.io.file.Path destinationFile, Option<String> container) {
        Object object;
        Option option = destinationFile.parent();
        if (option instanceof Some) {
            fs2.io.file.Path dir = (fs2.io.file.Path)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.execRequest(podName, (Seq<String>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sh", "-c", "mkdir -p " + dir}))), container, this.execRequest$default$4(), this.execRequest$default$5(), this.execRequest$default$6(), this.execRequest$default$7()), this.F()).flatMap((Function1 & Serializable)mkDirRequest -> this.wsClient.connectHighLevel(mkDirRequest).map((Function1 & Serializable)conn -> this.F().delay(() -> this.$anonfun$1$$anonfun$1$$anonfun$1(conn))).use((Function1 & Serializable)_$7 -> package.all$.MODULE$.toFlatMapOps(_$7, this.F()).flatMap((Function1 & Serializable)stdoutStream -> this.foldErrorStream((Stream<F, Either<ExecStream, Either<ParseFailure, Status>>>)stdoutStream)), this.F()));
        } else if (None$.MODULE$.equals(option)) {
            List list = (List)Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.List().empty());
            Tuple2 tuple2 = (Tuple2)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, (Object)None$.MODULE$));
            object = ApplicativeIdOps$.MODULE$.pure$extension((Object)tuple2, this.F());
        } else {
            throw new MatchError((Object)option);
        }
        Object mkDirResult = object;
        F uploadRequest2 = this.execRequest(podName, (Seq<String>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sh", "-c", "cat - >" + destinationFile}))), container, true, this.execRequest$default$5(), this.execRequest$default$6(), this.execRequest$default$7());
        Object uploadFileResult = package.all$.MODULE$.toFlatMapOps(uploadRequest2, this.F()).flatMap((Function1 & Serializable)uploadRequest -> this.wsClient.connectHighLevel(uploadRequest).use((Function1 & Serializable)connection -> {
            Stream source = Files$.MODULE$.apply(Files$.MODULE$.implicitForAsync(this.F())).readAll(sourceFile, 4096, Flags$.MODULE$.Read());
            Stream sendData = source.mapChunks((Function1 & Serializable)chunk -> Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new WSFrame.Binary[]{WSFrame.Binary$.MODULE$.apply(ByteVector$.MODULE$.apply(chunk.toChain().prepend((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StdInId())).toVector()), WSFrame.Binary$.MODULE$.$lessinit$greater$default$2())}))).through(connection.sendPipe());
            int retryAttempts = 5;
            Stream stream = (Stream)package.all$.MODULE$.catsSyntaxApplicativeError((Object)Stream$.MODULE$.retry(sendData.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F()))).drain(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(500)).millis(), (Function1 & Serializable)_$8 -> _$8.$times(2L), retryAttempts, Stream$.MODULE$.retry$default$5(), this.F(), RaiseThrowable$.MODULE$.fromApplicativeError(this.F())), (ApplicativeError)Stream$.MODULE$.monadErrorInstance(this.F()));
            Stream sendWithRetry = (Stream)ApplicativeErrorOps$.MODULE$.onError$extension((Object)stream, (PartialFunction)new Serializable(retryAttempts, this){
                private final int retryAttempts$1;
                private final /* synthetic */ NamespacedPodsApi $outer;
                {
                    this.retryAttempts$1 = retryAttempts$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return Stream$.MODULE$.eval(Logger$.MODULE$.apply(this.$outer.logger()).error(e, this::applyOrElse$$anonfun$1));
                }

                private final String applyOrElse$$anonfun$1() {
                    return "Failed send file data after " + this.retryAttempts$1 + " attempts";
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1()}, serializedLambda);
                }
            }, (ApplicativeError)Stream$.MODULE$.monadErrorInstance(this.F()));
            Stream result = Stream$.MODULE$.eval(SignallingRef$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), this.F())).map((Function1 & Serializable)signal -> {
                Stream stream = (Stream)package.all$.MODULE$.catsSyntaxApplyOps((Object)sendWithRetry);
                Stream dataStream = (Stream)ApplyOps$.MODULE$.$times$greater$extension((Object)stream, (Object)Stream$.MODULE$.eval(signal.set((Object)BoxesRunTime.boxToBoolean((boolean)true))), (Apply)Stream$.MODULE$.monadErrorInstance(this.F()));
                Stream output = connection.receiveStream().through(this.processWebSocketData()).interruptWhen((Signal)signal, this.F()).concurrently(dataStream, this.F());
                Object errors = package.all$.MODULE$.toFunctorOps(this.foldErrorStream(output), this.F()).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        List errors = (List)tuple2._1();
                        return errors;
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple4$.MODULE$.apply(signal, (Object)dataStream, (Object)output, errors);
            }).map((Function1 & Serializable)x$1 -> {
                Tuple4 tuple4 = x$1;
                if (tuple4 != null) {
                    SignallingRef signal = (SignallingRef)tuple4._1();
                    Stream dataStream = (Stream)tuple4._2();
                    Stream output = (Stream)tuple4._3();
                    Object errors = tuple4._4();
                    return errors;
                }
                throw new MatchError((Object)tuple4);
            });
            Object object = package.all$.MODULE$.catsSyntaxFlatten(result.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F()))).lastOrError(this.F()), this.F());
            return FlattenOps$.MODULE$.flatten$extension(object, this.F());
        }, this.F()));
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(mkDirResult, this.F()).map((Function1 & Serializable)result -> {
            Tuple2 tuple2 = result;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List errors = (List)tuple2._1();
            Option status = (Option)tuple2._2();
            Tuple2 $1$ = tuple2;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$1$, (Object)errors, (Object)status);
            Tuple2 $1$2 = (Tuple2)tuple3._1();
            List errors2 = (List)tuple3._2();
            Option status2 = (Option)tuple3._3();
            return Tuple2$.MODULE$.apply(result, (Object)$1$2);
        }), this.F()).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Tuple2 result = (Tuple2)tuple2._1();
                if (tuple22 != null) {
                    List errors = (List)tuple22._1();
                    Option status = (Option)tuple22._2();
                    return package.all$.MODULE$.toFunctorOps(uploadFileResult, this.F()).map((Function1 & Serializable)uploadErrors -> Tuple2$.MODULE$.apply(errors.$plus$plus((IterableOnce)uploadErrors), (Object)status));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Option<String> upload$default$4() {
        return None$.MODULE$;
    }

    public Resource<F, F> execStream(String podName, Option<String> container, Seq<String> command, boolean stdin, boolean stdout, boolean stderr, boolean tty) {
        return package$.MODULE$.Resource().eval(this.execRequest(podName, command, container, stdin, stdout, stderr, tty)).flatMap((Function1 & Serializable)request -> this.wsClient.connectHighLevel(request).map((Function1 & Serializable)connection -> this.F().delay(() -> this.execStream$$anonfun$1$$anonfun$1$$anonfun$1(connection))));
    }

    public Option<String> execStream$default$2() {
        return None$.MODULE$;
    }

    public Seq<String> execStream$default$3() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public boolean execStream$default$4() {
        return false;
    }

    public boolean execStream$default$5() {
        return true;
    }

    public boolean execStream$default$6() {
        return true;
    }

    public boolean execStream$default$7() {
        return false;
    }

    public F exec(String podName, Option<String> container, Seq<String> command, boolean stdin, boolean stdout, boolean stderr, boolean tty) {
        return (F)this.execStream(podName, container, command, stdin, stdout, stderr, tty).use((Function1 & Serializable)_$9 -> package.all$.MODULE$.toFlatMapOps(_$9, this.F()).flatMap((Function1 & Serializable)stdoutStream -> this.foldStream((Stream<F, Either<ExecStream, Either<ParseFailure, Status>>>)stdoutStream)), this.F());
    }

    public Option<String> exec$default$2() {
        return None$.MODULE$;
    }

    public Seq<String> exec$default$3() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public boolean exec$default$4() {
        return false;
    }

    public boolean exec$default$5() {
        return true;
    }

    public boolean exec$default$6() {
        return true;
    }

    public boolean exec$default$7() {
        return false;
    }

    private F foldStream(Stream<F, Either<ExecStream, Either<ParseFailure, Status>>> stdoutStream) {
        return (F)stdoutStream.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F()))).fold((Object)Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.List().empty(), (Object)package.all$.MODULE$.none()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                List accEvents = (List)tuple2._1();
                Option accStatus = (Option)tuple2._2();
                Either data = (Either)tuple22._2();
                Either either = data;
                if (either instanceof Left) {
                    ExecStream event = (ExecStream)((Left)either).value();
                    List list = (List)Predef$.MODULE$.ArrowAssoc(accEvents.$colon$plus((Object)event));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, (Object)accStatus);
                }
                if (either instanceof Right) {
                    Either errorOrStatus = (Either)((Right)either).value();
                    List list = (List)Predef$.MODULE$.ArrowAssoc((Object)accEvents);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, (Object)accStatus.orElse(() -> NamespacedPodsApi.foldStream$$anonfun$1$$anonfun$1(errorOrStatus)));
                }
                throw new MatchError((Object)either);
            }
            throw new MatchError((Object)tuple22);
        });
    }

    private F foldErrorStream(Stream<F, Either<ExecStream, Either<ParseFailure, Status>>> stdoutStream) {
        return (F)stdoutStream.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F()))).fold((Object)Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.List().empty(), (Object)package.all$.MODULE$.none()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                List accEvents = (List)tuple2._1();
                Option accStatus = (Option)tuple2._2();
                Either data = (Either)tuple22._2();
                Either either = data;
                if (either instanceof Left) {
                    Option option;
                    ExecStream event = (ExecStream)((Left)either).value();
                    ExecStream execStream = event;
                    if (execStream instanceof ExecStream.StdErr) {
                        ExecStream.StdErr e = (ExecStream.StdErr)execStream;
                        ExecStream.StdErr stdErr = (ExecStream.StdErr)package.all$.MODULE$.catsSyntaxOptionId((Object)e);
                        option = OptionIdOps$.MODULE$.some$extension((Object)stdErr);
                    } else {
                        option = package.all$.MODULE$.none();
                    }
                    List list = (List)Predef$.MODULE$.ArrowAssoc(accEvents.$plus$plus((IterableOnce)option.toList()));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, (Object)accStatus);
                }
                if (either instanceof Right) {
                    Either errorOrStatus = (Either)((Right)either).value();
                    List list = (List)Predef$.MODULE$.ArrowAssoc((Object)accEvents);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, (Object)accStatus.orElse(() -> NamespacedPodsApi.foldErrorStream$$anonfun$1$$anonfun$1(errorOrStatus)));
                }
                throw new MatchError((Object)either);
            }
            throw new MatchError((Object)tuple22);
        });
    }

    private Function1<Stream<F, WSDataFrame>, Stream<F, Either<ExecStream, Either<ParseFailure, Status>>>> processWebSocketData() {
        return (Function1 & Serializable)_$10 -> _$10.collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ NamespacedPodsApi $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(WSDataFrame x) {
                WSDataFrame wSDataFrame = x;
                if (wSDataFrame instanceof WSFrame.Binary) {
                    WSFrame.Binary binary = WSFrame.Binary$.MODULE$.unapply((WSFrame.Binary)wSDataFrame);
                    ByteVector byteVector = binary._1();
                    boolean bl = binary._2();
                    ByteVector data = byteVector;
                    if (data.headOption().contains((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StdOutId()))) {
                        return true;
                    }
                    ByteVector data2 = byteVector;
                    if (data2.headOption().contains((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StdErrId()))) {
                        return true;
                    }
                    ByteVector data3 = byteVector;
                    if (data3.headOption().contains((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StatusId()))) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(WSDataFrame x, Function1 function1) {
                WSDataFrame wSDataFrame = x;
                if (wSDataFrame instanceof WSFrame.Binary) {
                    WSFrame.Binary binary = WSFrame.Binary$.MODULE$.unapply((WSFrame.Binary)wSDataFrame);
                    ByteVector byteVector = binary._1();
                    boolean bl = binary._2();
                    ByteVector data = byteVector;
                    if (data.headOption().contains((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StdOutId()))) {
                        ExecStream.StdOut stdOut = (ExecStream.StdOut)package.all$.MODULE$.catsSyntaxEitherId((Object)ExecStream$StdOut$.MODULE$.apply(this.$outer.com$goyeau$kubernetes$client$api$NamespacedPodsApi$$dropRoutingByte(data).toArray()));
                        return EitherIdOps$.MODULE$.asLeft$extension((Object)stdOut);
                    }
                    ByteVector data2 = byteVector;
                    if (data2.headOption().contains((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StdErrId()))) {
                        ExecStream.StdErr stdErr = (ExecStream.StdErr)package.all$.MODULE$.catsSyntaxEitherId((Object)ExecStream$StdErr$.MODULE$.apply(this.$outer.com$goyeau$kubernetes$client$api$NamespacedPodsApi$$dropRoutingByte(data2).toArray()));
                        return EitherIdOps$.MODULE$.asLeft$extension((Object)stdErr);
                    }
                    ByteVector data3 = byteVector;
                    if (data3.headOption().contains((Object)BoxesRunTime.boxToByte((byte)ExecRouting$.MODULE$.StatusId()))) {
                        String json = this.$outer.com$goyeau$kubernetes$client$api$NamespacedPodsApi$$convertToString(this.$outer.com$goyeau$kubernetes$client$api$NamespacedPodsApi$$dropRoutingByte(data3));
                        Either either = package.all$.MODULE$.catsSyntaxEither(io.circe.parser.package$.MODULE$.decode(json, Status$.MODULE$.decoder()));
                        Either either2 = (Either)package.all$.MODULE$.catsSyntaxEitherId((Object)EitherOps$.MODULE$.leftFlatMap$extension(either, arg_0 -> NamespacedPodsApi.com$goyeau$kubernetes$client$api$NamespacedPodsApi$$anon$2$$_$applyOrElse$$anonfun$2(json, arg_0)));
                        return EitherIdOps$.MODULE$.asRight$extension((Object)either2);
                    }
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$goyeau$kubernetes$client$api$NamespacedPodsApi$$anon$2$$_$applyOrElse$$anonfun$2(java.lang.String io.circe.Error )}, serializedLambda);
            }
        });
    }

    public ByteVector com$goyeau$kubernetes$client$api$NamespacedPodsApi$$dropRoutingByte(ByteVector data) {
        return data.drop(1L);
    }

    public String com$goyeau$kubernetes$client$api$NamespacedPodsApi$$convertToString(ByteVector data) {
        return new String(data.toArray(), Charset$.MODULE$.UTF$minus8().nioCharset());
    }

    private F logRequest(String podName, Option<String> container, boolean follow, boolean insecureSkipTLSVerifyBackend, Option<Object> limitBytes, boolean pretty, boolean previous, Option<Object> sinceSeconds, Option<Object> tailLines, boolean timestamps) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"container");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"follow");
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"insecureSkipTLSVerifyBackend");
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"limitBytes");
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"pretty");
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"previous");
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"sinceSeconds");
        String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"tailLines");
        String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"timestamps");
        Uri uri = (Uri)this.config().server().resolve(this.resourceUri()).$div(podName).$div("log").$plus$qmark$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, container), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToBoolean((boolean)follow).toString()), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToBoolean((boolean)insecureSkipTLSVerifyBackend).toString()), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)limitBytes.map((Function1 & Serializable)_$12 -> NamespacedPodsApi.$anonfun$8(BoxesRunTime.unboxToLong((Object)_$12)))), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)BoxesRunTime.boxToBoolean((boolean)pretty).toString()), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)BoxesRunTime.boxToBoolean((boolean)previous).toString()), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)sinceSeconds.map((Function1 & Serializable)_$13 -> NamespacedPodsApi.$anonfun$9(BoxesRunTime.unboxToLong((Object)_$13)))), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)tailLines.map((Function1 & Serializable)_$14 -> NamespacedPodsApi.$anonfun$10(BoxesRunTime.unboxToLong((Object)_$14)))), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder()).$plus$qmark(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)BoxesRunTime.boxToBoolean((boolean)timestamps).toString()), QueryParamKeyLike$.MODULE$.stringKey(), QueryParamEncoder$.MODULE$.stringQueryParamEncoder());
        return com.goyeau.kubernetes.client.operation.package$.MODULE$.KubernetesRequestOps(Request$.MODULE$.apply(Method$.MODULE$.GET(), uri, Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()), this.F()).withOptionalAuthorization(this.authorization());
    }

    public Stream<F, Response<F>> log(String podName, Option<String> container, boolean follow, boolean insecureSkipTLSVerifyBackend, Option<Object> limitBytes, boolean pretty, boolean previous, Option<Object> sinceSeconds, Option<Object> tailLines, boolean timestamps) {
        return Stream$.MODULE$.eval(this.logRequest(podName, container, follow, insecureSkipTLSVerifyBackend, limitBytes, pretty, previous, sinceSeconds, tailLines, timestamps)).flatMap((Function1 & Serializable)request -> this.httpClient().stream(request), NotGiven$.MODULE$.value());
    }

    public Option<String> log$default$2() {
        return None$.MODULE$;
    }

    public boolean log$default$3() {
        return false;
    }

    public boolean log$default$4() {
        return false;
    }

    public Option<Object> log$default$5() {
        return None$.MODULE$;
    }

    public boolean log$default$6() {
        return false;
    }

    public boolean log$default$7() {
        return false;
    }

    public Option<Object> log$default$8() {
        return None$.MODULE$;
    }

    public Option<Object> log$default$9() {
        return None$.MODULE$;
    }

    public boolean log$default$10() {
        return false;
    }

    private static final Option download$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(Either statusOrError$2) {
        Either either = (Either)package.all$.MODULE$.catsSyntaxOptionId((Object)statusOrError$2);
        return OptionIdOps$.MODULE$.some$extension((Object)either);
    }

    private final Stream $anonfun$1$$anonfun$1$$anonfun$1(WSConnectionHighLevel conn$1) {
        return conn$1.receiveStream().through(this.processWebSocketData());
    }

    private final Stream execStream$$anonfun$1$$anonfun$1$$anonfun$1(WSConnectionHighLevel connection$2) {
        return connection$2.receiveStream().through(this.processWebSocketData());
    }

    private static final Option foldStream$$anonfun$1$$anonfun$1(Either errorOrStatus$5) {
        Either either = (Either)package.all$.MODULE$.catsSyntaxOptionId((Object)errorOrStatus$5);
        return OptionIdOps$.MODULE$.some$extension((Object)either);
    }

    private static final Option foldErrorStream$$anonfun$1$$anonfun$1(Either errorOrStatus$6) {
        Either either = (Either)package.all$.MODULE$.catsSyntaxOptionId((Object)errorOrStatus$6);
        return OptionIdOps$.MODULE$.some$extension((Object)either);
    }

    public static final /* synthetic */ Either com$goyeau$kubernetes$client$api$NamespacedPodsApi$$anon$2$$_$applyOrElse$$anonfun$2(String json$1, Error _$11) {
        ParseFailure parseFailure = (ParseFailure)package.all$.MODULE$.catsSyntaxEitherId((Object)ParseFailure$.MODULE$.apply(json$1));
        return EitherIdOps$.MODULE$.asLeft$extension((Object)parseFailure);
    }

    private static final /* synthetic */ String $anonfun$8(long _$12) {
        return BoxesRunTime.boxToLong((long)_$12).toString();
    }

    private static final /* synthetic */ String $anonfun$9(long _$13) {
        return BoxesRunTime.boxToLong((long)_$13).toString();
    }

    private static final /* synthetic */ String $anonfun$10(long _$14) {
        return BoxesRunTime.boxToLong((long)_$14).toString();
    }
}

