/*
 * Decompiled with CFR 0.152.
 */
package com.goyeau.kubernetes.client.api;

import cats.effect.kernel.Async;
import com.goyeau.kubernetes.client.KubeConfig;
import com.goyeau.kubernetes.client.operation.Creatable;
import com.goyeau.kubernetes.client.operation.Deletable;
import com.goyeau.kubernetes.client.operation.Gettable;
import com.goyeau.kubernetes.client.operation.GroupDeletable;
import com.goyeau.kubernetes.client.operation.Listable;
import com.goyeau.kubernetes.client.operation.Replaceable;
import com.goyeau.kubernetes.client.operation.Watchable;
import io.circe.Decoder;
import io.circe.Encoder;
import io.k8s.api.core.v1.Secret;
import io.k8s.api.core.v1.SecretList;
import io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta;
import java.io.Serializable;
import java.util.Base64;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.client.Client;
import org.typelevel.jawn.Facade;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.runtime.Statics;

public class NamespacedSecretsApi<F>
implements Creatable<F, Secret>,
Replaceable<F, Secret>,
Gettable<F, Secret>,
Listable<F, SecretList>,
Deletable<F>,
GroupDeletable<F>,
Watchable<F, Secret> {
    private Facade parserFacade;
    private final Client httpClient;
    private final KubeConfig config;
    private final Option authorization;
    private final Async F;
    private final Encoder resourceEncoder;
    private final Decoder resourceDecoder;
    private final Decoder listDecoder;
    private final Uri resourceUri;

    public NamespacedSecretsApi(Client<F> httpClient, KubeConfig<F> config, Option<Object> authorization, String namespace, Async<F> F, Encoder<Secret> resourceEncoder, Decoder<Secret> resourceDecoder, Decoder<SecretList> listDecoder) {
        this.httpClient = httpClient;
        this.config = config;
        this.authorization = authorization;
        this.F = F;
        this.resourceEncoder = resourceEncoder;
        this.resourceDecoder = resourceDecoder;
        this.listDecoder = listDecoder;
        Watchable.$init$(this);
        this.resourceUri = Uri$.MODULE$.unsafeFromString("/api").$div("v1").$div("namespaces").$div(namespace).$div("secrets");
        Statics.releaseFence();
    }

    @Override
    public Facade parserFacade() {
        return this.parserFacade;
    }

    @Override
    public void com$goyeau$kubernetes$client$operation$Watchable$_setter_$parserFacade_$eq(Facade x$0) {
        this.parserFacade = x$0;
    }

    @Override
    public Client<F> httpClient() {
        return this.httpClient;
    }

    @Override
    public KubeConfig<F> config() {
        return this.config;
    }

    @Override
    public Option<F> authorization() {
        return this.authorization;
    }

    @Override
    public Async<F> F() {
        return this.F;
    }

    @Override
    public Encoder<Secret> resourceEncoder() {
        return this.resourceEncoder;
    }

    @Override
    public Decoder<Secret> resourceDecoder() {
        return this.resourceDecoder;
    }

    @Override
    public Decoder<SecretList> listDecoder() {
        return this.listDecoder;
    }

    @Override
    public Uri resourceUri() {
        return this.resourceUri;
    }

    public F createEncode(Secret resource) {
        return (F)this.create(this.encode(resource));
    }

    public F createOrUpdateEncode(Secret resource) {
        return (F)this.createOrUpdate(this.encode(resource));
    }

    private Secret encode(Secret resource) {
        Option option = resource.data().map((Function1 & Serializable)_$3 -> (Map)_$3.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Base64.getEncoder().encodeToString(v.getBytes()));
            }
            throw new MatchError((Object)tuple2);
        }));
        Option<String> option2 = resource.copy$default$1();
        Option<Object> option3 = resource.copy$default$3();
        Option<String> option4 = resource.copy$default$4();
        Option<ObjectMeta> option5 = resource.copy$default$5();
        Option<Map<String, String>> option6 = resource.copy$default$6();
        Option<String> option7 = resource.copy$default$7();
        return resource.copy(option2, (Option<Map<String, String>>)option, option3, option4, option5, option6, option7);
    }
}

