/*
 * Decompiled with CFR 0.152.
 */
package com.goyeau.kubernetes.client.operation;

import cats.effect.kernel.Async;
import cats.implicits$;
import cats.kernel.Eq;
import cats.syntax.ApplicativeErrorOps$;
import com.goyeau.kubernetes.client.KubeConfig;
import com.goyeau.kubernetes.client.operation.package$;
import com.goyeau.kubernetes.client.util.CirceEntityCodec$;
import io.circe.Decoder;
import io.circe.Encoder;
import io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.MediaType$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.client.Client;
import org.http4s.client.UnexpectedStatus;
import org.http4s.client.UnexpectedStatus$;
import org.http4s.headers.Content$minusType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Selectable$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.language$;
import scala.runtime.ScalaRunTime$;

public interface Creatable<F, Resource> {
    public Client<F> httpClient();

    public Async<F> F();

    public KubeConfig<F> config();

    public Uri resourceUri();

    public Option<F> authorization();

    public Encoder<Resource> resourceEncoder();

    public Decoder<Resource> resourceDecoder();

    public static Object create$(Creatable $this, Object resource) {
        return $this.create(resource);
    }

    default public F create(Resource resource) {
        return (F)this.httpClient().status(this.buildRequest(resource));
    }

    public static Object createWithResource$(Creatable $this, Object resource) {
        return $this.createWithResource(resource);
    }

    default public F createWithResource(Resource resource) {
        return (F)this.httpClient().expect(this.buildRequest(resource), CirceEntityCodec$.MODULE$.circeEntityDecoder(this.F(), this.resourceDecoder()));
    }

    private F buildRequest(Resource resource) {
        return package$.MODULE$.KubernetesRequestOps((Request)Request$.MODULE$.apply(Method$.MODULE$.POST(), this.config().server().resolve(this.resourceUri()), Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()).withEntity(resource, CirceEntityCodec$.MODULE$.circeEntityEncoder(this.resourceEncoder())), this.F()).withOptionalAuthorization(this.authorization());
    }

    public static Object createOrUpdate$(Creatable $this, Object resource) {
        return $this.createOrUpdate(resource);
    }

    default public F createOrUpdate(Resource resource) {
        Uri fullResourceUri = this.config().server().resolve(this.resourceUri()).$div((String)((ObjectMeta)((Option)Selectable$.MODULE$.reflectiveSelectableFromLangReflectiveCalls(resource, language$.MODULE$.reflectiveCalls()).selectDynamic("metadata")).get()).name().get());
        return (F)implicits$.MODULE$.toFlatMapOps(this.httpClient().status(package$.MODULE$.KubernetesRequestOps(Request$.MODULE$.apply(Method$.MODULE$.GET(), fullResourceUri, Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()), this.F()).withOptionalAuthorization(this.authorization())), this.F()).flatMap((Function1 & Serializable)x$12 -> {
            Status status = x$12;
            Status status2 = status;
            if (status2.isSuccess()) {
                return this.update$1(resource, fullResourceUri);
            }
            Status status3 = Status$.MODULE$.NotFound();
            Status status4 = status;
            if (!(status3 != null ? !status3.equals(status4) : status4 != null)) {
                return implicits$.MODULE$.toFlatMapOps(this.create(resource), this.F()).flatMap((Function1 & Serializable)x$1 -> {
                    Status status = x$1;
                    Status status2 = Status$.MODULE$.Conflict();
                    Status status3 = status;
                    if (!(status2 != null ? !status2.equals(status3) : status3 != null)) {
                        return this.update$1(resource, fullResourceUri);
                    }
                    Status status4 = status;
                    return this.F().pure((Object)status4);
                });
            }
            Status status5 = status;
            return this.F().pure((Object)status5);
        });
    }

    public static Object createOrUpdateWithResource$(Creatable $this, Object resource) {
        return $this.createOrUpdateWithResource(resource);
    }

    default public F createOrUpdateWithResource(Resource resource) {
        Uri fullResourceUri = this.config().server().resolve(this.resourceUri()).$div((String)((ObjectMeta)((Option)Selectable$.MODULE$.reflectiveSelectableFromLangReflectiveCalls(resource, language$.MODULE$.reflectiveCalls()).selectDynamic("metadata")).get()).name().get());
        return (F)implicits$.MODULE$.toFlatMapOps(package$.MODULE$.HttpClientOps(this.httpClient(), this.F()).expectOptionF(package$.MODULE$.KubernetesRequestOps(Request$.MODULE$.apply(Method$.MODULE$.GET(), fullResourceUri, Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()), this.F()).withOptionalAuthorization(this.authorization()), CirceEntityCodec$.MODULE$.circeEntityDecoder(this.F(), this.resourceDecoder())), this.F()).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                return this.com$goyeau$kubernetes$client$operation$Creatable$$_$updateWithResource$1(resource, fullResourceUri);
            }
            if (None$.MODULE$.equals(option)) {
                Object object = implicits$.MODULE$.catsSyntaxApplicativeError(this.createWithResource(resource), this.F());
                return ApplicativeErrorOps$.MODULE$.recoverWith$extension(object, (PartialFunction)new Serializable(resource, fullResourceUri, this){
                    private final Object resource$6;
                    private final Uri fullResourceUri$6;
                    private final /* synthetic */ Creatable $outer;
                    {
                        this.resource$6 = resource$7;
                        this.fullResourceUri$6 = fullResourceUri$7;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        if (throwable instanceof UnexpectedStatus) {
                            UnexpectedStatus unexpectedStatus = UnexpectedStatus$.MODULE$.unapply((UnexpectedStatus)throwable);
                            Status status = unexpectedStatus._1();
                            Method method = unexpectedStatus._2();
                            Uri uri = unexpectedStatus._3();
                            Status status2 = status;
                            if (implicits$.MODULE$.catsSyntaxEq((Object)status2, (Eq)Status$.MODULE$.http4sOrderForStatus()).$eq$eq$eq((Object)Status$.MODULE$.Conflict())) {
                                return true;
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable instanceof UnexpectedStatus) {
                            UnexpectedStatus unexpectedStatus = UnexpectedStatus$.MODULE$.unapply((UnexpectedStatus)throwable);
                            Status status = unexpectedStatus._1();
                            Method method = unexpectedStatus._2();
                            Uri uri = unexpectedStatus._3();
                            Status status2 = status;
                            if (implicits$.MODULE$.catsSyntaxEq((Object)status2, (Eq)Status$.MODULE$.http4sOrderForStatus()).$eq$eq$eq((Object)Status$.MODULE$.Conflict())) {
                                return this.$outer.com$goyeau$kubernetes$client$operation$Creatable$$_$updateWithResource$1(this.resource$6, this.fullResourceUri$6);
                            }
                        }
                        return function1.apply((Object)x);
                    }
                }, this.F());
            }
            throw new MatchError((Object)option);
        });
    }

    private F buildRequest(Resource resource, Uri fullResourceUri) {
        return package$.MODULE$.KubernetesRequestOps((Request)Request$.MODULE$.apply(Method$.MODULE$.PATCH(), fullResourceUri, Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()).withEntity(resource, CirceEntityCodec$.MODULE$.circeEntityEncoder(this.resourceEncoder())).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusType$.MODULE$.apply(MediaType$.MODULE$.application().merge$minuspatch$plusjson()), Content$minusType$.MODULE$.headerInstance())})), this.F()).withOptionalAuthorization(this.authorization());
    }

    private Object update$1(Object resource$1, Uri fullResourceUri$1) {
        return this.httpClient().status(this.buildRequest(resource$1, fullResourceUri$1));
    }

    public static Object com$goyeau$kubernetes$client$operation$Creatable$$_$updateWithResource$1$(Creatable $this, Object resource$3, Uri fullResourceUri$3) {
        return $this.com$goyeau$kubernetes$client$operation$Creatable$$_$updateWithResource$1(resource$3, fullResourceUri$3);
    }

    default public Object com$goyeau$kubernetes$client$operation$Creatable$$_$updateWithResource$1(Object resource$3, Uri fullResourceUri$3) {
        return this.httpClient().expect(this.buildRequest(resource$3, fullResourceUri$3), CirceEntityCodec$.MODULE$.circeEntityDecoder(this.F(), this.resourceDecoder()));
    }
}

