package io.k8s.apimachinery.pkg.apis.meta.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** APIGroup contains the name, the supported versions, and the preferred version of a group.
 *
 *  @param                       name  name is the name of the group.
 *  @param                   versions  versions are the versions supported in this group.
 *  @param                 apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers
 *                                     should convert recognized schemas to the latest internal value, and may reject unrecognized
 *                                     values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param                       kind  Kind is a string value representing the REST resource this object represents. Servers
 *                                     may infer this from the endpoint the client submits requests to. Cannot be updated. In
 *                                     CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param           preferredVersion  preferredVersion is the version preferred by the API server, which probably is the storage
 *                                     version.
 *  @param serverAddressByClientCIDRs  a map of client CIDR to server address that is serving this group. This is to help clients
 *                                     reach servers in the most network-efficient way possible. Clients can use the appropriate
 *                                     server address as per the CIDR that they match. In case of multiple matches, clients
 *                                     should use the longest matching CIDR. The server returns only those CIDRs that it thinks
 *                                     that the client can match. For example: the master will return an internal IP CIDR only,
 *                                     if the client reaches the server using an internal IP. Server looks at X-Forwarded-For
 *                                     header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.
*/
case class APIGroup(
  name: String,
  versions: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery],
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  preferredVersion: Option[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery] = None,
  serverAddressByClientCIDRs: Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR]] = None
)

object APIGroup {
  implicit lazy val encoder: Encoder.AsObject[APIGroup] = deriveEncoder
  implicit lazy val decoder: Decoder[APIGroup] = deriveDecoder
}
