package io.k8s.api.rbac.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole
 *
 *  @param clusterRoleSelectors  ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and
 *                               create the rules. If any of the selectors match, then the ClusterRole's permissions will be
 *                               added
*/
case class AggregationRule(
  clusterRoleSelectors: Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]] = None
)

object AggregationRule {
  implicit lazy val encoder: Encoder.AsObject[AggregationRule] = deriveEncoder
  implicit lazy val decoder: Decoder[AggregationRule] = deriveDecoder
}
