package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** AppArmorProfile defines a pod or container's AppArmor settings.
 *
 *  @param           `type`  type indicates which kind of AppArmor profile will be applied. Valid options are:
 *                           Localhost - a profile pre-loaded on the node.
 *                           RuntimeDefault - the container runtime's default profile.
 *                           Unconfined - no AppArmor enforcement.
 *  @param localhostProfile  localhostProfile indicates a profile loaded on the node that should be used. The profile must
 *                           be preconfigured on the node to work. Must match the loaded name of the profile. Must be set if
 *                           and only if type is "Localhost".
*/
case class AppArmorProfile(
  `type`: String,
  localhostProfile: Option[String] = None
)

object AppArmorProfile {
  implicit lazy val encoder: Encoder.AsObject[AppArmorProfile] = deriveEncoder
  implicit lazy val decoder: Decoder[AppArmorProfile] = deriveDecoder
}
