package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** AttachedVolume describes a volume attached to a node
 *
 *  @param       name  Name of the attached volume
 *  @param devicePath  DevicePath represents the device path where the volume should be available
*/
case class AttachedVolume(
  name: String,
  devicePath: String
)

object AttachedVolume {
  implicit lazy val encoder: Encoder.AsObject[AttachedVolume] = deriveEncoder
  implicit lazy val decoder: Decoder[AttachedVolume] = deriveDecoder
}
