package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
 *
 *  @param    diskName  diskName is the Name of the data disk in the blob storage
 *  @param     diskURI  diskURI is the URI of data disk in the blob storage
 *  @param cachingMode  cachingMode is the Host Caching mode: None, Read Only, Read Write.
 *  @param      fsType  fsType is Filesystem type to mount. Must be a filesystem type supported by the host operating system.
 *                      Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
 *  @param        kind  kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk
 *                      per storage account  Managed: azure managed data disk (only in managed availability set). defaults to
 *                      shared
 *  @param    readOnly  readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts
*/
case class AzureDiskVolumeSource(
  diskName: String,
  diskURI: String,
  cachingMode: Option[String] = None,
  fsType: Option[String] = None,
  kind: Option[String] = None,
  readOnly: Option[Boolean] = None
)

object AzureDiskVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[AzureDiskVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[AzureDiskVolumeSource] = deriveDecoder
}
