package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ClusterTrustBundleProjection describes how to select a set of ClusterTrustBundle objects and project their contents into the pod filesystem.
 *
 *  @param          path  Relative path from the volume root to write the bundle.
 *  @param labelSelector  Select all ClusterTrustBundles that match this label selector.  Only has effect if signerName is
 *                        set.  Mutually-exclusive with name.  If unset, interpreted as "match nothing".  If set but empty,
 *                        interpreted as "match everything".
 *  @param          name  Select a single ClusterTrustBundle by object name.  Mutually-exclusive with signerName and labelSelector
 *  @param      optional  If true, don't block pod startup if the referenced ClusterTrustBundle(s) aren't available.  If using
 *                        name, then the named ClusterTrustBundle is allowed not to exist.  If using signerName, then the combination
 *                        of signerName and labelSelector is allowed to match zero ClusterTrustBundles.
 *  @param    signerName  Select all ClusterTrustBundles that match this signer name. Mutually-exclusive with name.  The contents
 *                        of all selected ClusterTrustBundles will be unified and deduplicated.
*/
case class ClusterTrustBundleProjection(
  path: String,
  labelSelector: Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  name: Option[String] = None,
  optional: Option[Boolean] = None,
  signerName: Option[String] = None
)

object ClusterTrustBundleProjection {
  implicit lazy val encoder: Encoder.AsObject[ClusterTrustBundleProjection] = deriveEncoder
  implicit lazy val decoder: Decoder[ClusterTrustBundleProjection] = deriveDecoder
}
