package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ComponentStatus (and ComponentStatusList) holds the cluster validation info. Deprecated: This API is deprecated in v1.19+
 *
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param conditions  List of component conditions observed
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
*/
case class ComponentStatus(
  apiVersion: Option[String] = None,
  conditions: Option[Seq[io.k8s.api.core.v1.ComponentCondition]] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
)

object ComponentStatus {
  implicit lazy val encoder: Encoder.AsObject[ComponentStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[ComponentStatus] = deriveDecoder
}
