package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.

The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
 *
 *  @param     name  Name of the referent. This field is effectively required, but due to backwards compatibility is allowed
 *                   to be empty. Instances of this type with an empty value here are almost certainly wrong. More info:
 *                   https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
 *  @param optional  Specify whether the ConfigMap must be defined
*/
case class ConfigMapEnvSource(
  name: Option[String] = None,
  optional: Option[Boolean] = None
)

object ConfigMapEnvSource {
  implicit lazy val encoder: Encoder.AsObject[ConfigMapEnvSource] = deriveEncoder
  implicit lazy val decoder: Decoder[ConfigMapEnvSource] = deriveDecoder
}
