package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Selects a key from a ConfigMap.
 *
 *  @param      key  The key to select.
 *  @param     name  Name of the referent. This field is effectively required, but due to backwards compatibility is allowed
 *                   to be empty. Instances of this type with an empty value here are almost certainly wrong. More info:
 *                   https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
 *  @param optional  Specify whether the ConfigMap or its key must be defined
*/
case class ConfigMapKeySelector(
  key: String,
  name: Option[String] = None,
  optional: Option[Boolean] = None
)

object ConfigMapKeySelector {
  implicit lazy val encoder: Encoder.AsObject[ConfigMapKeySelector] = deriveEncoder
  implicit lazy val decoder: Decoder[ConfigMapKeySelector] = deriveDecoder
}
