package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ContainerResizePolicy represents resource resize policy for the container.
 *
 *  @param  resourceName  Name of the resource to which this resource resize policy applies. Supported values: cpu, memory.
 *  @param restartPolicy  Restart policy to apply when specified resource is resized. If not specified, it defaults to NotRequired
*/
case class ContainerResizePolicy(
  resourceName: String,
  restartPolicy: String
)

object ContainerResizePolicy {
  implicit lazy val encoder: Encoder.AsObject[ContainerResizePolicy] = deriveEncoder
  implicit lazy val decoder: Decoder[ContainerResizePolicy] = deriveDecoder
}
