package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting.
 *
 *  @param    running  Details about a running container
 *  @param terminated  Details about a terminated container
 *  @param    waiting  Details about a waiting container
*/
case class ContainerState(
  running: Option[io.k8s.api.core.v1.ContainerStateRunning] = None,
  terminated: Option[io.k8s.api.core.v1.ContainerStateTerminated] = None,
  waiting: Option[io.k8s.api.core.v1.ContainerStateWaiting] = None
)

object ContainerState {
  implicit lazy val encoder: Encoder.AsObject[ContainerState] = deriveEncoder
  implicit lazy val decoder: Decoder[ContainerState] = deriveDecoder
}
