package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ContainerStateTerminated is a terminated state of a container.
 *
 *  @param    exitCode  Exit status from the last termination of the container
 *  @param containerID  Container's ID in the format '<type>://<container_id>'
 *  @param  finishedAt  Time at which the container last terminated
 *  @param     message  Message regarding the last termination of the container
 *  @param      reason  (brief) reason from the last termination of the container
 *  @param      signal  Signal from the last termination of the container
 *  @param   startedAt  Time at which previous execution of the container started
*/
case class ContainerStateTerminated(
  exitCode: Int,
  containerID: Option[String] = None,
  finishedAt: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message: Option[String] = None,
  reason: Option[String] = None,
  signal: Option[Int] = None,
  startedAt: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
)

object ContainerStateTerminated {
  implicit lazy val encoder: Encoder.AsObject[ContainerStateTerminated] = deriveEncoder
  implicit lazy val decoder: Decoder[ContainerStateTerminated] = deriveDecoder
}
