package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ContainerUser represents user identity information
 *
 *  @param linux  Linux holds user identity information initially attached to the first process of the containers in Linux.
 *                Note that the actual running identity can be changed if the process has enough privilege to do so.
*/
case class ContainerUser(
  linux: Option[io.k8s.api.core.v1.LinuxContainerUser] = None
)

object ContainerUser {
  implicit lazy val encoder: Encoder.AsObject[ContainerUser] = deriveEncoder
  implicit lazy val decoder: Decoder[ContainerUser] = deriveDecoder
}
