package io.k8s.api.batch.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** CronJobStatus represents the current state of a cron job.
 *
 *  @param             active  A list of pointers to currently running jobs.
 *  @param   lastScheduleTime  Information when was the last time the job was successfully scheduled.
 *  @param lastSuccessfulTime  Information when was the last time the job successfully completed.
*/
case class CronJobStatus(
  active: Option[Seq[io.k8s.api.core.v1.ObjectReference]] = None,
  lastScheduleTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  lastSuccessfulTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
)

object CronJobStatus {
  implicit lazy val encoder: Encoder.AsObject[CronJobStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[CronJobStatus] = deriveDecoder
}
